/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.Item;

public class ImageItem
extends Item {
    public static final int LAYOUT_DEFAULT = 0;
    public static final int LAYOUT_LEFT = 1;
    public static final int LAYOUT_RIGHT = 2;
    public static final int LAYOUT_CENTER = 3;
    public static final int LAYOUT_NEWLINE_BEFORE = 256;
    public static final int LAYOUT_NEWLINE_AFTER = 512;
    Image img;
    String altText;
    private int appearanceMode;

    public ImageItem(String string, Image image, int n2, String string2) {
        this(string, image, n2, string2, 0);
    }

    public ImageItem(String string, Image image, int n2, String string2, int n3) {
        super(string);
        this.setLayout(n2);
        if (n3 != 0 && n3 != 1 && n3 != 2) {
            throw new IllegalArgumentException();
        }
        this.setImage(image);
        this.altText = string2;
        this.appearanceMode = n3;
    }

    public String getAltText() {
        return this.altText;
    }

    public int getAppearanceMode() {
        return this.appearanceMode;
    }

    public Image getImage() {
        return this.img;
    }

    public int getLayout() {
        return super.getLayout();
    }

    public void setAltText(String string) {
        this.altText = string;
    }

    public void setImage(Image image) {
        if (image != null && image.isMutable()) {
            image = Image.createImage(image);
        }
        this.img = image;
        this.repaint();
    }

    public void setLayout(int n2) {
        super.setLayout(n2);
    }

    int getHeight() {
        if (this.img == null) {
            return super.getHeight();
        }
        return super.getHeight() + this.img.getHeight();
    }

    int paint(Graphics graphics) {
        super.paintContent(graphics);
        if (this.img != null) {
            graphics.translate(0, super.getHeight());
            if (this.layout == 0 || this.layout == 1) {
                graphics.drawImage(this.img, 0, 0, 20);
            } else if (this.layout == 2) {
                graphics.drawImage(this.img, this.owner.getWidth(), 0, 24);
            } else if (this.layout == 3) {
                graphics.drawImage(this.img, this.owner.getWidth() / 2, 0, 17);
            } else {
                graphics.drawImage(this.img, 0, 0, 20);
            }
            graphics.translate(0, -super.getHeight());
        }
        return this.getHeight();
    }

    int traverse(int n2, int n3, int n4, boolean bl2) {
        Font font = Font.getDefaultFont();
        if (n2 == 1) {
            if (n3 > 0) {
                if (n3 % font.getHeight() == 0) {
                    return -font.getHeight();
                }
                return -(n3 % font.getHeight());
            }
            return Integer.MAX_VALUE;
        }
        if (n2 == 6) {
            if (n4 < this.getHeight()) {
                if (this.getHeight() - n4 < font.getHeight()) {
                    return this.getHeight() - n4;
                }
                return font.getHeight();
            }
            return Integer.MAX_VALUE;
        }
        return 0;
    }
}

