/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui.game;

import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.Layer;

public class LayerManager {
    private Vector layers = new Vector();
    private int viewX;
    private int viewY;
    private int viewW;
    private int viewH;

    public LayerManager() {
        LayerManager layerManager = this;
        layerManager.viewY = 0;
        layerManager.viewX = 0;
        LayerManager layerManager2 = this;
        layerManager2.viewH = Integer.MAX_VALUE;
        layerManager2.viewW = Integer.MAX_VALUE;
    }

    public void append(Layer layer) {
        LayerManager layerManager = this;
        synchronized (layerManager) {
            if (layer == null) {
                throw new NullPointerException();
            }
            this.layers.add(layer);
            return;
        }
    }

    public Layer getLayerAt(int n2) {
        return (Layer)this.layers.get(n2);
    }

    public int getSize() {
        return this.layers.size();
    }

    public void insert(Layer layer, int n2) {
        LayerManager layerManager = this;
        synchronized (layerManager) {
            if (layer == null) {
                throw new NullPointerException();
            }
            this.layers.insertElementAt(layer, n2);
            return;
        }
    }

    public void remove(Layer layer) {
        LayerManager layerManager = this;
        synchronized (layerManager) {
            if (layer == null) {
                throw new NullPointerException();
            }
            this.layers.remove(layer);
            return;
        }
    }

    public void setViewWindow(int n2, int n3, int n4, int n5) {
        LayerManager layerManager = this;
        synchronized (layerManager) {
            if (n4 < 0 || n5 < 0) {
                throw new IllegalArgumentException();
            }
            this.viewX = n2;
            this.viewY = n3;
            this.viewW = n4;
            this.viewH = n5;
            return;
        }
    }

    public void paint(Graphics graphics, int n2, int n3) {
        LayerManager layerManager = this;
        synchronized (layerManager) {
            if (graphics == null) {
                throw new NullPointerException();
            }
            int n4 = graphics.getClipX();
            int n5 = graphics.getClipY();
            int n6 = graphics.getClipWidth();
            int n7 = graphics.getClipHeight();
            graphics.translate(n2 - this.viewX, n3 - this.viewY);
            graphics.clipRect(this.viewX, this.viewY, this.viewW, this.viewH);
            int n8 = this.getSize();
            while (--n8 >= 0) {
                Layer layer = this.getLayerAt(n8);
                if (!layer.isVisible()) continue;
                layer.paint(graphics);
            }
            graphics.translate(-n2 + this.viewX, -n3 + this.viewY);
            graphics.setClip(n4, n5, n6, n7);
            return;
        }
    }
}

